package ru.yandex.chemodan.app.queller;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.queller.admin.QuellerAdminContextConfiguration;
import ru.yandex.chemodan.app.queller.bazinga.QuellerBazingaContextConfiguration;
import ru.yandex.chemodan.app.queller.celery.QuellerCeleryContextConfiguration;
import ru.yandex.chemodan.app.queller.celery.settings.monitor.CeleryMonitorContextConfiguration;
import ru.yandex.chemodan.app.queller.web.QuellerActionsContextConfiguration;
import ru.yandex.chemodan.boot.DiskAppVersion;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.misc.version.AppName;

/**
 * @author dbrylev
 * @author yashunsky
 */
@Configuration
@Import({
        QuellerCeleryContextConfiguration.class,
        QuellerBazingaContextConfiguration.class,
        QuellerActionsContextConfiguration.class,
        QuellerAdminContextConfiguration.class,
        CeleryMonitorContextConfiguration.class,
})
public class QuellerContextConfiguration {

    @Bean
    public ApplicationInfo applicationInfo(AppName appName, DiskAppVersion appVersion) {
        return new ApplicationInfo(appName.appName(), appVersion.getProjectVersion());
    }
}
