package ru.yandex.chemodan.app.queller;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.misc.db.monica.JdbcMetricsSwitch;
import ru.yandex.misc.log.mlf.Level;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author dbrylev
 */
public class QuellerMain extends ChemodanMainSupport {

    public static void main(String[] args) {
        JdbcMetricsSwitch.ENABLED = true;
        JdbcMetricsSwitch.COMMAND_METRICS_ENABLED = true;
        new QuellerMain().runMain(args);
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("disk", "queller");
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(
                ChemodanCommonContextConfiguration.class,
                QuellerContextConfiguration.class);
    }

    @Override
    protected void configureLogger() {
        super.configureLogger();
        Log4jHelper.configureLogger("ru.yandex.chemodan.queller.rabbit.patchedSpringAmqp", Level.INFO);
    }
}
