package ru.yandex.chemodan.app.queller.admin;

import java.util.function.Function;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.commune.json.JsonArray;
import ru.yandex.commune.json.JsonString;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class CeleryAutocomplete {
    public final String jsonizedTaskIds;
    public final String jsonizedQueueNames;
    public final String jsonizedDcNames;
    public final String jsonizedConductorGroups;
    public final String jsonizedHostPatterns;

    public CeleryAutocomplete(
            CollectionF<String> taskIds, CollectionF<String> queueNames,
            CollectionF<String> dcNames, CollectionF<String> conductorGroups, CollectionF<String> hostPatterns)
    {
        Function<CollectionF<String>, String> serializeF =
                lst -> new JsonArray(lst.map(JsonString::valueOf)).serialize();

        this.jsonizedTaskIds = serializeF.apply(taskIds);
        this.jsonizedQueueNames = serializeF.apply(queueNames);
        this.jsonizedDcNames = serializeF.apply(dcNames);
        this.jsonizedConductorGroups = serializeF.apply(conductorGroups);
        this.jsonizedHostPatterns = serializeF.apply(hostPatterns);
    }
}
