package ru.yandex.chemodan.app.queller.admin;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.app.queller.celery.settings.queue.CeleryQueueSettings;
import ru.yandex.chemodan.app.queller.celery.settings.queue.CeleryQueueSettingsRegistry;
import ru.yandex.chemodan.app.queller.celery.settings.task.CeleryTaskRegistry;
import ru.yandex.chemodan.app.queller.celery.settings.worker.WorkerAssignmentRulesManager;
import ru.yandex.chemodan.app.queller.celery.settings.worker.rules.RuleScope;
import ru.yandex.chemodan.app.queller.celery.settings.worker.rules.WorkerAssignmentRules;
import ru.yandex.chemodan.queller.celery.job.CeleryTask;

/**
 * @author dbrylev
 */
public class CeleryRegistries {
    private final CeleryTaskRegistry taskRegistry;
    private final CeleryQueueSettingsRegistry queueSettingsRegistry;
    private final WorkerAssignmentRulesManager workerAssignmentRulesManager;

    public CeleryRegistries(
            CeleryTaskRegistry taskRegistry,
            CeleryQueueSettingsRegistry queueSettingsRegistry,
            WorkerAssignmentRulesManager workerAssignmentRulesManager)
    {
        this.taskRegistry = taskRegistry;
        this.queueSettingsRegistry = queueSettingsRegistry;
        this.workerAssignmentRulesManager = workerAssignmentRulesManager;
    }

    public CeleryTaskRegistry tasks() {
        return taskRegistry;
    }

    public CeleryQueueSettingsRegistry queues() {
        return queueSettingsRegistry;
    }

    public WorkerAssignmentRulesManager assignments() {
        return workerAssignmentRulesManager;
    }

    private static final ListF<String> DC_NAMES = Cf.list("fol", "iva", "myt", "sas", "ugr");

    public CeleryAutocomplete autocomplete() {
        ListF<CeleryTask> tasks = tasks().getAllNonDefaults();
        ListF<CeleryQueueSettings> queues = queues().getAllNonDefaults();

        SetF<String> ruleQueues = Cf.hashSet();
        SetF<String> conductorGroups = Cf.hashSet();
        SetF<String> hostPatterns = Cf.hashSet();

        Function1V<RuleScope> processScopeF = scope -> {
            if (scope instanceof RuleScope.Host) {
                hostPatterns.add(((RuleScope.Host) scope).regex);
            }
        };
        WorkerAssignmentRules rules = assignments().getRules();

        rules.workerPoolRules.forEach(w -> w.rules.forEach(r -> {
            ruleQueues.addAll(r.queuesPool.queues);
            processScopeF.apply(r.scope);
        }));

        rules.queuesDenyRules.forEach(r -> {
            ruleQueues.addAll(r.queues);
            processScopeF.apply(r.scope);
        });

        ListF<String> queueNames = queues.map(s -> s.name)
                .plus(tasks.map(t -> t.executionQueue))
                .plus(ruleQueues)
                .stableUnique();

        ListF<String> taskIds = tasks.map(t -> t.id.getId());

        return new CeleryAutocomplete(taskIds, queueNames, DC_NAMES, conductorGroups, hostPatterns);
    }
}
