package ru.yandex.chemodan.app.queller.admin;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.admin.common.CommonLocator;
import ru.yandex.chemodan.admin.lib.LibLocator;
import ru.yandex.chemodan.app.queller.admin.queues.QueuesAdminPage;
import ru.yandex.chemodan.app.queller.admin.rules.RulesAdminPage;
import ru.yandex.chemodan.app.queller.admin.tasks.TasksAdminPage;
import ru.yandex.chemodan.app.queller.celery.settings.queue.CeleryQueueSettingsRegistry;
import ru.yandex.chemodan.app.queller.celery.settings.task.CeleryTaskRegistry;
import ru.yandex.chemodan.app.queller.celery.settings.worker.WorkerAssignmentRulesManager;
import ru.yandex.chemodan.queller.admin.CeleryMonitorAdminContextConfiguration;
import ru.yandex.chemodan.queller.rabbit.RabbitPoolContextConfiguration;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.zk2.admin.ZkAdminContextConfiguration;

/**
 * @author dbrylev
 * @author yashunsky
 */
@Configuration
@Import({
        ZkAdminContextConfiguration.class,
        RabbitPoolContextConfiguration.class,
        CeleryMonitorAdminContextConfiguration.class,
})
public class QuellerAdminContextConfiguration {

    @Autowired
    private AdminApp adminApp;

    @PostConstruct
    public void init() {
        adminApp.registerHiddenAdminPage("lib", new LibLocator());
        adminApp.registerHiddenAdminPage("common", new CommonLocator());
    }

    @Bean
    public CeleryRegistries celeryRegistries(
            CeleryTaskRegistry taskRegistry,
            CeleryQueueSettingsRegistry queueSettingsRegistry,
            WorkerAssignmentRulesManager workerAssignmentRulesManager)
    {
        return new CeleryRegistries(taskRegistry, queueSettingsRegistry, workerAssignmentRulesManager);
    }

    @Bean
    public TasksAdminPage tasksAdminPage(CeleryRegistries celeryRegistries) {
        TasksAdminPage page = new TasksAdminPage(celeryRegistries);
        adminApp.registerAdminPage("Tasks", Option.of("Celery"), page);

        return page;
    }

    @Bean
    public RulesAdminPage rulesAdminPage(CeleryRegistries celeryRegistries) {
        RulesAdminPage page = new RulesAdminPage(celeryRegistries);
        adminApp.registerAdminPage("Rules", Option.of("Celery"), page);

        return page;
    }

    @Bean
    public QueuesAdminPage queuesAdminPage(CeleryRegistries celeryRegistries) {
        QueuesAdminPage page = new QueuesAdminPage(celeryRegistries);
        adminApp.registerAdminPage("Queues", Option.of("Celery"), page);

        return page;
    }
}
