<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        exclude-result-prefixes="xsl xs z"
        xmlns:z="urn:zscript-functions"
        version="2.0">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/lib/bootstrap-typeahead.min.js"/>
        <script type="text/javascript" src="/z/r/lib/jquery.serialize-object.min.js"/>
        <script type="text/javascript" src="/z/r/common/modal-edit-form.js"/>
        <script type="text/javascript" src="/z/r/celery-queues/queue-edit.js"/>
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
        <link rel="stylesheet" type="text/css" href="/z/r/lib/bootstrap-select.min.css"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div class="row" style="margin: 0 -10px">
            <xsl:apply-templates select="queues-defaults"/>
            <xsl:apply-templates select="queues/*"/>
        </div>
        <xsl:apply-templates select="." mode="modal-edit-form"/>
    </xsl:template>

    <xsl:template match="queue | queues-defaults">
        <div class="task col-md-3">
            <div class="thumbnail">
                <div class="caption">
                    <h4>
                        <a name="{name}"/>
                        <xsl:value-of select="name"/>
                    </h4>

                    <dl class="dl-horizontal">
                        <dt>Enqueable from local</dt>
                        <dd>
                            <xsl:value-of select="enqueue-from-local-length-limit"/>
                        </dd>
                        <dt>Enqueable from global</dt>
                        <dd>
                            <xsl:value-of select="enqueue-from-global-length-limit"/>
                        </dd>
                    </dl>

                    <div class="btn-toolbar">
                        <a href="#" class="btn btn-default"
                           onclick="return QueueEditor.edit('{name}')">Edit</a>

                        <a href="#" class="btn btn-default"
                           onclick="return QueueEditor.clone('{name}')">Clone</a>

                        <xsl:if test="name(.) != 'queues-defaults'">
                            <div class="pull-right">
                                <a href="/z/celery-queues/delete?name={name}" class="btn btn-danger"
                                   onclick="return confirm('Are you sure?')">Delete</a>
                            </div>
                        </xsl:if>
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>

    <xsl:include href="classpath:ru/yandex/chemodan/admin/common/modal-edit-form.xsl"/>

    <xsl:template match="content" mode="modal-edit-form">
        <xsl:call-template name="modal-edit-form">
            <xsl:with-param name="id" select="'queue-edit'"/>
            <xsl:with-param name="size" select="'s'"/>

            <xsl:with-param name="content">
                <xsl:apply-templates select="." mode="edit-form"/>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="content" mode="edit-form">
        <form class="queue-edit-form">
            <dl class="dl-horizontal">
                <div class="modal-edit-id">
                    <dt>Queue name</dt>
                    <dd>
                        <div class="form-group">
                            <input name="name" type="text" class="form-control"
                                   data-provide="typeahead" data-source="{jsonized-queue-names}" autocomplete="off"/>
                        </div>
                    </dd>
                </div>
                <dt>Enqueable from local</dt>
                <dd>
                    <div class="form-group">
                        <input name="enqueueFromLocalLengthLimit" type="text" class="form-control"/>
                    </div>
                </dd>
                <dt>Enqueable from global</dt>
                <dd>
                    <div class="form-group">
                        <input name="enqueueFromGlobalLengthLimit" type="text" class="form-control"/>
                    </div>
                </dd>
            </dl>
        </form>
    </xsl:template>

</xsl:stylesheet>
