package ru.yandex.chemodan.app.queller.admin.queues;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.admin.AdminBenderParameterBinder;
import ru.yandex.chemodan.app.queller.admin.CeleryAutocomplete;
import ru.yandex.chemodan.app.queller.admin.CeleryRegistries;
import ru.yandex.chemodan.app.queller.celery.settings.queue.CeleryQueueSettings;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.result.NoContent;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.annotation.XmlRootElement;

/**
 * @author dbrylev
 */
@ActionContainer
public class QueuesAdminPage {

    private final CeleryRegistries registries;

    public QueuesAdminPage(CeleryRegistries registries) {
        this.registries = registries;
    }

    @ZAction(defaultAction = true)
    @Path("/celery-queues")
    public QueuesPojo index() {
        return new QueuesPojo(
                registries.queues().getDefaults(),
                registries.queues().getAllNonDefaults(),
                registries.autocomplete());
    }

    @Path("/celery-queues/queue")
    public CeleryQueueSettings get(@RequestParam("name") String name) {
        return registries.queues().getOrDefault(name);
    }

    @Path(value = "/celery-queues/queue", methods = HttpMethod.POST)
    public NoContent save(@BindWith(AdminBenderParameterBinder.class) CeleryQueueSettings queue) {
        registries.queues().put(queue);

        return NoContent.cons();
    }

    @Path("/celery-queues/delete")
    public void delete(@RequestParam("name") String name) {
        registries.queues().remove(name);

        throw new ZRedirectException("/z/celery-queues");
    }

    @XmlRootElement(name = "content")
    @BenderBindAllFields
    public static class QueuesPojo {
        public final CeleryQueueSettings queuesDefaults;
        @BenderPart(name = "queue", wrapperName = "queues")
        public final ListF<CeleryQueueSettings> queues;
        @BenderFlatten
        public final CeleryAutocomplete celeryAutocomplete;

        public QueuesPojo(
                CeleryQueueSettings queuesDefaults,
                ListF<CeleryQueueSettings> queues,
                CeleryAutocomplete celeryAutocomplete)
        {
            this.queuesDefaults = queuesDefaults;
            this.queues = queues;
            this.celeryAutocomplete = celeryAutocomplete;
        }
    }
}
