<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        exclude-result-prefixes="xsl xs z"
        xmlns:z="urn:zscript-functions"
        version="2.0">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/lib/bootstrap-select.min.js"/>
        <script type="text/javascript" src="/z/r/lib/bootstrap-typeahead.min.js"/>
        <script type="text/javascript" src="/z/r/lib/jquery.serialize-object.min.js"/>
        <script type="text/javascript" src="/z/r/common/modal-edit-form.js"/>
        <script type="text/javascript" src="/z/r/common/typeahead-multicomplete.js"/>
        <script type="text/javascript" src="/z/r/celery-rules/rules-edit.js"/>
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
        <link rel="stylesheet" type="text/css" href="/z/r/lib/bootstrap-select.min.css"/>
        <link rel="stylesheet" type="text/css" href="/z/r/celery-rules/rules.css"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div class="page-header">
            <a href="#" class="btn btn-default"
               onclick="return WorkerRulesEditor.create()">Add worker</a>
        </div>

        <div class="row" style="margin: 0 -10px">
            <xsl:apply-templates select="queues-deny-rules"/>
            <xsl:apply-templates select="worker-pool-rules/rule"/>
        </div>
        <xsl:apply-templates select="." mode="modal-edit-form"/>
    </xsl:template>

    <xsl:template match="queues-deny-rules">
        <div class="queues col-md-4">
            <div class="thumbnail">
                <div class="caption">
                    <h4>Denied queues</h4>

                    <table class="table">
                        <tbody>
                            <xsl:apply-templates select="rule"/>
                        </tbody>
                    </table>

                    <div class="btn-toolbar">
                        <a href="#" class="btn btn-default"
                           onclick="return DeniedQueuesEditor.edit()">Edit</a>
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="worker-pool-rules/rule">
        <div class="worker col-md-4">
            <div class="thumbnail">
                <div class="caption">
                    <h4>
                        <a name="{worker}"/>
                        <xsl:value-of select="worker"/>
                    </h4>

                    <table class="table">
                        <thead>
                            <tr>
                                <th/>
                                <th>Queues</th>
                                <th class="col-md-2">Pool</th>
                            </tr>
                        </thead>
                        <tbody>
                            <xsl:apply-templates select="rules"/>
                        </tbody>
                    </table>

                    <div class="btn-toolbar">
                        <a href="#" class="btn btn-default"
                           onclick="return WorkerRulesEditor.edit('{worker}')">Edit</a>

                        <div class="pull-right">
                            <a href="/z/celery-rules/worker/delete?name={worker}" class="btn btn-danger"
                               onclick="return confirm('Are you sure?')">Delete</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="*" mode="scope-queues-cells">
        <th>
            <xsl:variable name="type" select="scope/@__type"/>

            <xsl:if test="$type = 'global'">
                <xsl:text>*</xsl:text>
            </xsl:if>

            <xsl:if test="$type = 'dc'">
                <xsl:value-of select="string-join(scope/names, ', ')"/>
            </xsl:if>

            <xsl:variable name="groups">
                <xsl:for-each select="scope/group-names | scope/names">
                    <xsl:value-of select="concat('%', .)"/>
                    <xsl:if test="position() != last()">
                        <xsl:text>, </xsl:text>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>

            <xsl:if test="$type = 'group'">
                <xsl:value-of select="$groups"/>
            </xsl:if>

            <xsl:if test="$type = 'group-plus-dc'">
                <xsl:value-of select="$groups"/>
                <xsl:text> + </xsl:text>
                <xsl:value-of select="string-join(scope/dc-names, ', ')"/>
            </xsl:if>

            <xsl:if test="$type = 'host'">
                <xsl:value-of select="scope/regex"/>
            </xsl:if>
        </th>
        <td>
            <xsl:value-of select="string-join(queues, ', ')"/>
        </td>
    </xsl:template>

    <xsl:template match="queues-deny-rules/rule">
        <tr>
            <xsl:apply-templates select="." mode="scope-queues-cells"/>
        </tr>
    </xsl:template>

    <xsl:template match="worker-pool-rules/rule/rules">
        <tr>
            <xsl:apply-templates select="." mode="scope-queues-cells"/>
            <td>
                <xsl:value-of select="pool-size"/>
            </td>
        </tr>
    </xsl:template>

    <xsl:include href="classpath:ru/yandex/chemodan/admin/common/modal-edit-form.xsl"/>

    <xsl:template match="content" mode="modal-edit-form">
        <xsl:call-template name="modal-edit-form">
            <xsl:with-param name="id" select="'worker-edit'"/>

            <xsl:with-param name="content">
                <xsl:apply-templates select="." mode="worker-edit-form"/>
            </xsl:with-param>
        </xsl:call-template>

        <xsl:call-template name="modal-edit-form">
            <xsl:with-param name="id" select="'queues-deny'"/>

            <xsl:with-param name="content">
                <xsl:apply-templates select="." mode="queues-edit-form"/>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="content" mode="worker-edit-form">
        <form class="worker-edit-form">
            <div class="modal-edit-id form-group">
                <label for="email">Worker name</label>
                <input name="worker" type="text" class="form-control"/>
            </div>
            <table class="table rules-container">
                <thead>
                    <tr>
                        <th class="col-md-1">Scope</th>
                        <th>Scope params</th>
                        <th>Queues</th>
                        <th class="col-md-1">Pool</th>
                        <th class="col-md-0"/>
                    </tr>
                </thead>
                <tbody class="rules">
                </tbody>
            </table>
            <span class="rules-add">
                <span class="glyphicon glyphicon-plus"/>
                <span>Add rule</span>
            </span>
        </form>
        <table class="hidden">
            <tr class="rule template">
                <td class="scope-type">
                    <xsl:apply-templates select="." mode="scope-type-select"/>
                </td>
                <td class="scope-params">
                    <xsl:apply-templates select="." mode="scope-params"/>
                </td>
                <td>
                    <input name="rules[][queues]" class="form-control" type="text" placeholder="Queue names"
                           data-provide="typeaheadMulti" data-source="{jsonized-queue-names}" autocomplete="off"/>
                </td>
                <td>
                    <input name="rules[][poolSize]" class="form-control" type="text" placeholder="Size"/>
                </td>
                <td>
                    <span class="glyphicon glyphicon-remove remove"/>
                </td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template match="content" mode="queues-edit-form">
        <form class="queues-edit-form">
            <div class="modal-edit-id">
                <input type="hidden" value=""/>
            </div>
            <table class="table rules-container">
                <thead>
                    <tr>
                        <th class="col-md-1">Scope</th>
                        <th>Scope params</th>
                        <th>Queues</th>
                        <th class="col-md-1"/>
                    </tr>
                </thead>
                <tbody class="rules">
                </tbody>
            </table>
            <span class="rules-add">
                <span class="glyphicon glyphicon-plus"/>
                <span>Add rule</span>
            </span>
        </form>
        <table class="hidden">
            <tr class="rule template">
                <td class="scope-type">
                    <xsl:apply-templates select="." mode="scope-type-select"/>
                </td>
                <td class="scope-params">
                    <xsl:apply-templates select="." mode="scope-params"/>
                </td>
                <td>
                    <input name="rules[][queues]" class="form-control" type="text" placeholder="Queue names"
                           data-provide="typeaheadMulti" data-source="{jsonized-queue-names}" autocomplete="off"/>
                </td>
                <td>
                    <span class="glyphicon glyphicon-remove remove"/>
                </td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template match="content" mode="scope-type-select">
        <xsl:variable name="options">
            <op value="global">Global</op>
            <op value="dc">Data centers</op>
            <op value="group">Conductor groups</op>
            <op value="groupPlusDc">Groups + Dcs</op>
            <op value="host">Host</op>
        </xsl:variable>

        <select name="{z:scope-field-name('type')}" style="display: none">
            <xsl:for-each select="$options/*">
                <option value="{@value}">
                    <xsl:value-of select="."/>
                </option>
            </xsl:for-each>
        </select>
    </xsl:template>

    <xsl:template match="content" mode="scope-params">
        <div id="global"/>

        <div id="dc" style="display: none">
            <input name="{z:scope-field-name('dc')}[names]"
                   class="form-control" type="text" placeholder="Data center names"
                   data-provide="typeaheadMulti" data-source="{jsonized-dc-names}" autocomplete="off"/>
        </div>

        <div id="group" style="display: none">
            <input name="{z:scope-field-name('group')}[names]"
                   class="form-control" type="text" placeholder="Conductor groups"
                   data-provide="typeaheadMulti" data-source="{jsonized-conductor-groups}" autocomplete="off"/>
        </div>

        <div id="groupPlusDc" style="display: none">
            <div class="form-group">
                <input name="{z:scope-field-name('groupPlusDc')}[groupNames]"
                       class="form-control" type="text" placeholder="Conductor groups"
                       data-provide="typeaheadMulti" data-source="{jsonized-conductor-groups}" autocomplete="off"/>
            </div>

            <input name="{z:scope-field-name('groupPlusDc')}[dcNames]"
                   class="form-control" type="text" placeholder="Data center names"
                   data-provide="typeaheadMulti" data-source="{jsonized-dc-names}" autocomplete="off"/>
        </div>
        <div id="host" style="display: none">
            <input name="{z:scope-field-name('host')}[regex]"
                   class="form-control" type="text" placeholder="Host matching regexp"
                   data-provide="typeahead" data-source="{jsonized-host-patterns}" autocomplete="off"/>
        </div>
    </xsl:template>

    <xsl:function name="z:scope-field-name">
        <xsl:param name="name"/>

        <xsl:value-of select="concat('rules[][scope][', $name, ']')"/>
    </xsl:function>

</xsl:stylesheet>
