package ru.yandex.chemodan.app.queller.admin.rules;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.admin.AdminBenderParameterBinder;
import ru.yandex.chemodan.app.queller.admin.CeleryAutocomplete;
import ru.yandex.chemodan.app.queller.admin.CeleryRegistries;
import ru.yandex.chemodan.app.queller.celery.settings.worker.rules.DeniedQueuesRules;
import ru.yandex.chemodan.app.queller.celery.settings.worker.rules.QueuesDenyRule;
import ru.yandex.chemodan.app.queller.celery.settings.worker.rules.QueuesPoolRule;
import ru.yandex.chemodan.app.queller.celery.settings.worker.rules.WorkerAssignmentRules;
import ru.yandex.chemodan.app.queller.celery.settings.worker.rules.WorkerQueuesPoolRules;
import ru.yandex.chemodan.queller.celery.worker.WorkerName;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.result.NoContent;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.annotation.XmlRootElement;

/**
 * @author dbrylev
 */
@ActionContainer
public class RulesAdminPage {

    private final CeleryRegistries registries;

    public RulesAdminPage(CeleryRegistries registries) {
        this.registries = registries;
    }

    @ZAction(defaultAction = true)
    @Path("/celery-rules")
    public RulesPojo index() {
        WorkerAssignmentRules rules = registries.assignments().getRules();

        ListF<WorkerQueuesPoolRules> poolRules = rules.workerPoolRules
                .sortedBy(r -> r.worker.name)
                .map(r -> new WorkerQueuesPoolRules(r.worker, r.rules.sortedBy(QueuesPoolRule::priority)));

        ListF<QueuesDenyRule> denyRules = rules.queuesDenyRules
                .sortedBy(r -> r.scope.priority());

        return new RulesPojo(poolRules, denyRules, registries.autocomplete());
    }

    @Path("/celery-rules/worker")
    public WorkerQueuesPoolRules getWorkerRules(@RequestParam("name") String name) {
        return registries.assignments().getWorkerRules(new WorkerName(name));
    }

    @Path(value = "/celery-rules/worker", methods = HttpMethod.POST)
    public NoContent saveWorkerRules(@BindWith(AdminBenderParameterBinder.class) WorkerQueuesPoolRules rules) {
        rules.rules.forEach(r -> r.scope.validate());

        registries.assignments().saveRules(rules);
        return NoContent.cons();
    }

    @Path("/celery-rules/denied-queues")
    public DeniedQueuesRules getDeniedQueues() {
        return registries.assignments().getDeniedQueuesRules();
    }

    @Path(value = "/celery-rules/denied-queues", methods = HttpMethod.POST)
    public NoContent saveDeniedQueues(@BindWith(AdminBenderParameterBinder.class) DeniedQueuesRules rules) {
        rules.rules.forEach(r -> r.scope.validate());

        registries.assignments().saveRules(rules);
        return NoContent.cons();
    }

    @Path("/celery-rules/worker/delete")
    public void delete(@RequestParam("name") String name) {
        registries.assignments().remove(new WorkerName(name));
        throw new ZRedirectException("/z/celery-rules");
    }

    @XmlRootElement(name = "content")
    @BenderBindAllFields
    public static class RulesPojo {
        @BenderPart(name = "rule", wrapperName = "worker-pool-rules")
        public final ListF<WorkerQueuesPoolRules> workerPoolRules;
        @BenderPart(name = "rule", wrapperName = "queues-deny-rules")
        public final ListF<QueuesDenyRule> queuesDenyRules;
        @BenderFlatten
        public final CeleryAutocomplete celeryAutocomplete;

        public RulesPojo(
                ListF<WorkerQueuesPoolRules> workerPoolRules,
                ListF<QueuesDenyRule> queuesDenyRules,
                CeleryAutocomplete celeryAutocomplete)
        {
            this.workerPoolRules = workerPoolRules;
            this.queuesDenyRules = queuesDenyRules;
            this.celeryAutocomplete = celeryAutocomplete;
        }
    }
}
