RulesEditor = function($element, url) {
    this.$element = $element;

    this.$rules = $element.find('.rules');
    this.$ruleTemplate = $element.find('.rule.template');
    this.$rulesContainer = $element.find('.rules-container');

    ModalEdit.call(this, $element, url);
    this.initEvents();
};

RulesEditor.prototype = $.extend({}, ModalEdit.prototype, {
    initEvents: function() {
        var self = this;

        self.$rules.on('change', '.scope-type select', function() {
            $(this).closest('.rule').find('.scope-params')
                .children().hide().end()
                .find('#' + $(this).val()).show();
        });

        self.$rules.on('click', '.rule .remove', function() {
            $(this).closest('.rule').remove();
            self.toggleRules();
        });

        self.$element.find('.rules-add').click(function() {
            self.templateRule().appendTo(self.$rules).find('select').change();
            self.toggleRules();
            self.updateHeight();
        });
    },

    templateRule: function() {
        return this.$ruleTemplate.clone().removeClass('template')
            .find('select').selectpicker().end();
    },

    toggleRules: function() {
        this.$rulesContainer.toggle(!!this.$rules.find('.rule').length);
    },

    clear: function() {
        this.$rules.find('.rule .remove').click();
        this.$element.find(':input').val('');
        this.toggleRules();
    },

    serialize: function() {
        var split = function(value) {
            return $.map(value.split(','), function(v) {
                return v.trim() || [];
            })
        };
        var serialized = this.$element.find('form').serializeObject();

        $.each(serialized.rules || [], function(_, rule) {
            var params = rule.scope[rule.scope.type];

            $.each(params || [], function(k, v) {
                params[k] = k == 'regex' ? v : split(v);
            });

            rule.scope = $.extend(params, { type: rule.scope.type });
            rule.queues = split(rule.queues);
        });
        return JSON.stringify(serialized);
    },

    deserialize: function(data) {
        var self = this;

        $.each(data.rules, function(_, rule) {
            var $rule = self.templateRule().appendTo(self.$rules);

            var input = function($el, name) {
                return $el.find(':input[name=\'rules[]' + name + '\']');
            };
            input($rule, '[queues]').val(rule.queues.join(', '));
            input($rule, '[poolSize]').val(rule.poolSize);
            input($rule, '[scope][type]').val(rule.scope.type).change();

            var $params = $rule.find('#' + rule.scope.type);

            input($params, '[scope][dc][names]').val((rule.scope.names || []).join(', '));
            input($params, '[scope][group][names]').val((rule.scope.names || []).join(', '));
            input($params, '[scope][groupPlusDc][groupNames]').val((rule.scope.groupNames || []).join(', '));
            input($params, '[scope][groupPlusDc][dcNames]').val((rule.scope.dcNames || []).join(', '));
            input($params, '[scope][host][regex]').val(rule.scope.regex);
        });
        self.toggleRules();
    }
});

WorkerRulesEditor = new RulesEditor($('.worker-edit'), '/z/celery-rules/worker.json?name={id}');

DeniedQueuesEditor = $.extend(new RulesEditor($('.queues-deny'), '/z/celery-rules/denied-queues.json'), {
    title: function() {
        return 'Denied queues';
    }
});
