<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        exclude-result-prefixes="xsl xs z"
        xmlns:z="urn:zscript-functions"
        version="2.0">

    <xsl:import href="admin://common.xsl"/>

    <xsl:variable name="active-uid-duplicate-options">
        <op value="do-nothing">Do nothing</op>
        <op value="merge-if-ready">Merge if ready</op>
        <op value="merge">Merge</op>
    </xsl:variable>

    <xsl:variable name="active-uid-drop-options">
        <op value="when-running">When running</op>
        <op value="when-finished">When finished</op>
    </xsl:variable>

    <xsl:variable name="reschedule-type-options">
        <op value="immediately">Immediately</op>
        <op value="constant">Constant</op>
        <op value="linear">Linear</op>
        <op value="exponential">Exponential</op>
    </xsl:variable>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/lib/bootstrap-select.min.js"/>
        <script type="text/javascript" src="/z/r/lib/bootstrap-typeahead.min.js"/>
        <script type="text/javascript" src="/z/r/lib/jquery.serialize-object.min.js"/>
        <script type="text/javascript" src="/z/r/common/modal-edit-form.js"/>
        <script type="text/javascript" src="/z/r/celery-tasks/task-edit.js"/>
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
        <link rel="stylesheet" type="text/css" href="/z/r/lib/bootstrap-select.min.css"/>
        <link rel="stylesheet" type="text/css" href="/z/r/celery-tasks/task-edit.css"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div class="row" style="margin: 0 -10px">
            <xsl:apply-templates select="task-defaults"/>
            <xsl:apply-templates select="tasks/*"/>
        </div>
        <xsl:apply-templates select="." mode="modal-edit-form"/>
    </xsl:template>

    <xsl:template match="task | task-defaults">
        <div class="task col-md-4">
            <div class="thumbnail">
                <div class="caption">
                    <h4>
                        <a name="{id}"/>
                        <xsl:value-of select="id"/>
                    </h4>

                    <dl class="dl-horizontal">
                        <dt>Queue</dt>
                        <dd>
                            <xsl:value-of select="queue"/>
                        </dd>
                        <dt>Priority</dt>
                        <dd>
                            <xsl:value-of select="priority"/>
                        </dd>
                        <dt>Soft timeout</dt>
                        <dd>
                            <xsl:value-of select="soft-timeout/pretty"/>
                        </dd>
                        <dt>Hard timeout</dt>
                        <dd>
                            <xsl:value-of select="hard-timeout/pretty"/>
                        </dd>
                        <dt>Active uid on duplicate</dt>
                        <dd>
                            <xsl:value-of select="replace(active-uid-on-duplicate, '-', ' ')"/>
                        </dd>
                        <dt>Active uid drop</dt>
                        <dd>
                            <xsl:value-of select="replace(active-uid-drop, '-', ' ')"/>
                        </dd>

                        <dt>Reschedule</dt>
                        <dd>
                            <xsl:for-each select="reschedules/*">
                                <xsl:value-of select="type"/>
                                <xsl:if test="delay">
                                    <xsl:value-of select="concat(' ', delay/pretty)"/>
                                </xsl:if>
                                <xsl:value-of select="concat(' ', times, ' times')"/>
                                <xsl:if test="position() != last()">
                                    <br/>
                                </xsl:if>
                            </xsl:for-each>
                        </dd>
                    </dl>
                    <div class="btn-toolbar">
                        <a href="#" class="btn btn-default"
                           onclick="return TaskEditor.edit('{id}')">Edit</a>

                        <a href="#" class="btn btn-default"
                           onclick="return TaskEditor.clone('{id}')">Clone</a>

                        <xsl:if test="name(.) != 'task-defaults'">
                            <div class="pull-right">
                                <a href="/z/celery-tasks/delete?id={id}" class="btn btn-danger"
                                   onclick="return confirm('Are you sure?')">Delete</a>
                            </div>
                        </xsl:if>
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>

    <xsl:include href="classpath:ru/yandex/chemodan/admin/common/modal-edit-form.xsl"/>

    <xsl:template match="content" mode="modal-edit-form">
        <xsl:call-template name="modal-edit-form">
            <xsl:with-param name="id" select="'task-edit'"/>

            <xsl:with-param name="content">
                <xsl:apply-templates select="." mode="edit-form"/>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="content" mode="edit-form">
        <form class="task-edit-form">
            <dl class="dl-horizontal">
                <div class="modal-edit-id">
                    <dt>Id</dt>
                    <dd>
                        <div class="form-group">
                            <input name="id" type="text" class="form-control"
                                   data-provide="typeahead" data-source="{jsonized-task-ids}" autocomplete="off"/>
                        </div>
                    </dd>
                </div>
                <dt>Queue</dt>
                <dd>
                    <div class="form-group">
                        <input name="queue" type="text" class="form-control"
                               data-provide="typeahead" data-source="{jsonized-queue-names}" autocomplete="off"/>
                    </div>
                </dd>
                <dt>Priority</dt>
                <dd>
                    <div class="form-group">
                        <input name="priority" type="text" class="form-control"/>
                    </div>
                </dd>
                <dt>Soft timeout</dt>
                <dd>
                    <div class="form-group">
                        <input name="softTimeout[value]" type="text" class="form-control" placeholder="HH:MM:SS"/>
                    </div>
                </dd>
                <dt>Hard timeout</dt>
                <dd>
                    <div class="form-group">
                        <input name="hardTimeout[value]" type="text" class="form-control" placeholder="HH:MM:SS"/>
                    </div>
                </dd>
                <dt>Active uid on duplicate</dt>
                <dd>
                    <div class="form-group">
                        <xsl:copy-of select="z:select-box(
                                'activeUidOnDuplicate', $active-uid-duplicate-options, 'selectpicker')"/>
                    </div>
                </dd>
                <dt>Active uid drop</dt>
                <dd>
                    <div class="form-group">
                        <xsl:copy-of select="z:select-box(
                                'activeUidDrop', $active-uid-drop-options, 'selectpicker')"/>
                    </div>
                </dd>
                <dt>Reschedule</dt>
                <dd class="reschedule">
                    <span class="glyphicon glyphicon-plus reschedule-rules-start"/>

                    <div class="reschedule-rules" style="display: none">
                        <div>
                            <xsl:call-template name="reschedule-fields-row">
                                <xsl:with-param name="values">
                                    <label>Type</label>

                                    <label>Times</label>

                                    <label>Delay</label>
                                </xsl:with-param>
                            </xsl:call-template>
                        </div>
                    </div>
                </dd>
            </dl>
        </form>

        <div class="reschedule-rule template">
            <xsl:call-template name="reschedule-fields-row">
                <xsl:with-param name="values">
                    <xsl:copy-of select="z:select-box(
                            'reschedules[][type]', $reschedule-type-options, 'reschedule-rule-type')"/>

                    <input name="reschedules[][times]" class="form-control" type="text"/>

                    <div class="form-group">
                        <input class="form-control reschedule-rule-delay-holder" disabled=""/>

                        <input name="reschedules[][delay][value]"
                               class="form-control reschedule-rule-delay"
                               style="display: none" type="text" placeholder="HH:MM:SS"/>
                    </div>
                </xsl:with-param>
            </xsl:call-template>

            <span class="glyphicon glyphicon-plus plus"/>
            <span class="glyphicon glyphicon-remove remove"/>
        </div>
    </xsl:template>

    <xsl:template name="reschedule-fields-row">
        <xsl:param name="values"/>

        <div class="bootstrap-select form-group-cell">
            <xsl:copy-of select="$values/*[1]"/>
        </div>

        <div class="col-xs-2 form-group-cell">
            <xsl:copy-of select="$values/*[2]"/>
        </div>

        <div class="col-xs-3 form-group-cell">
            <xsl:copy-of select="$values/*[3]"/>
        </div>
    </xsl:template>

    <xsl:function name="z:select-box">
        <xsl:param name="name"/>
        <xsl:param name="options"/>
        <xsl:param name="classes"/>

        <select class="{$classes}" name="{$name}" style="display: none">
            <xsl:for-each select="$options/*">
                <option value="{@value}">
                    <xsl:value-of select="."/>
                </option>
            </xsl:for-each>
        </select>

    </xsl:function>

    <xsl:function name="z:iff">
        <xsl:param name="condition"/>
        <xsl:param name="positiveValue"/>
        <xsl:param name="negativeValue"/>

        <xsl:choose>
            <xsl:when test="$condition">
                <xsl:copy-of select="$positiveValue"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="$negativeValue"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

</xsl:stylesheet>
