TaskEditor = function($element) {
    this.$element = $element;

    this.$reschedule = $element.find('.reschedule');
    this.$rescheduleRules = this.$reschedule.find('.reschedule-rules');
    this.$rescheduleRulesStart = this.$reschedule.find('.reschedule-rules-start');
    this.$ruleTemplate = $element.find('.reschedule-rule.template');

    ModalEdit.call(this, $element, '/z/celery-tasks/task.json?id={id}');
    this.initEvents();
};

TaskEditor.prototype = $.extend({}, ModalEdit.prototype, {
    initEvents: function() {
        var self = this;

        self.$rescheduleRules.on('change', '.reschedule-rule-type', function() {
            var $rule = $(this).closest('.reschedule-rule'),
                disabled = $(this).val() == 'immediately';

            $rule.find('.reschedule-rule-delay').toggle(!disabled);
            $rule.find('.reschedule-rule-delay-holder').toggle(disabled);
        });

        self.$rescheduleRulesStart.click(function() {
            self.$rescheduleRules.append(self.templateRescheduleRule());
            self.toggleReschedule();
        });

        self.$rescheduleRules.on('click', '.reschedule-rule .plus', function() {
            self.templateRescheduleRule().insertAfter($(this).closest('.reschedule-rule'));
            self.updateHeight();
        });

        self.$rescheduleRules.on('click', '.reschedule-rule .remove', function() {
            $(this).closest('.reschedule-rule').remove();
            self.toggleReschedule();
        });
    },

    templateRescheduleRule: function() {
        return this.$ruleTemplate.clone().removeClass('template')
            .find('select').selectpicker().end();
    },

    toggleReschedule: function() {
        var hasRules = !!this.$rescheduleRules.find('.reschedule-rule').length;

        this.$rescheduleRulesStart.toggle(!hasRules);
        this.$rescheduleRules.toggle(hasRules);
    },

    clear: function() {
        this.$reschedule.find('.reschedule-rules .reschedule-rule .remove').click();
        this.$element.find(':input').val('');
        this.toggleReschedule();
    },

    deserialize: function(data) {
        var self = this;

        $.each(data, function(key, value) {
            var input = function(name) {
                return self.$element.find(':input[name=\'' + name + '\']');
            };

            if (key == 'reschedules') {
                $.each(value, function(_, rule) {
                    self.templateRescheduleRule().appendTo(self.$rescheduleRules)
                        .find(':input[name=\'reschedules[][type]\']').val(rule.type).change().end()
                        .find(':input[name=\'reschedules[][times]\']').val(rule.times).end()
                        .find(':input[name=\'reschedules[][delay][value]\']').val((rule.delay || {}).value).end()
                });
                self.toggleReschedule();

            } else if (key == 'hardTimeout' || key == 'softTimeout') {
                input(key + '[value]').val(value.value);

            } else {
                input(key).val(value).change();
            }
        });
    }
});

TaskEditor = new TaskEditor($('.task-edit'));
