package ru.yandex.chemodan.app.queller.bazinga;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.bazinga.PgBazingaFetcherConfigurationContextConfiguration;
import ru.yandex.chemodan.bazinga.PgBazingaStorageConfigurationContextConfiguration;
import ru.yandex.commune.bazinga.impl.worker.BazingaHostPort;
import ru.yandex.commune.bazinga.pg.context.PgBazingaFetcherContextConfiguration;
import ru.yandex.misc.ip.IpPort;
import ru.yandex.misc.net.HostnameUtils;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        PgBazingaStorageConfigurationContextConfiguration.class,
        PgBazingaFetcherConfigurationContextConfiguration.class,
        PgBazingaFetcherContextConfiguration.class,
})
public class QuellerBazingaContextConfiguration {

    @Bean
    public BazingaHostPort bazingaWorkerId(
            @Value("${queller.bazinga.worker-id.port}") IpPort port)
    {
        return new BazingaHostPort(HostnameUtils.localHostname(), port.getPort());
    }
}
