package ru.yandex.chemodan.app.queller.celery.routing;

import org.springframework.amqp.core.Queue;

import ru.yandex.bolts.collection.Option;

public abstract class BazingaReaction {

    public boolean isDone() {
        return this instanceof Done;
    }

    public boolean isSendToExecution() {
        return this instanceof SendToExecution;
    }

    public Option<SendToExecution> asSendToExecution() {
        return isSendToExecution() ? Option.of((SendToExecution) this) : Option.empty();
    }

    public boolean isSendToExecutionOrRestoreReady() {
        return this instanceof SendToExecutionOrRestoreReady;
    }

    public boolean isSendToRejected() {
        return this instanceof SendToRejected;
    }

    public Option<SendToRejected> asSendToRejected() {
        return isSendToRejected() ? Option.of((SendToRejected) this) : Option.empty();
    }

    public boolean isMoveToAnotherRejected(Option<Queue> sourceQueue) {
        return asSendToRejected().exists(r -> !sourceQueue.isSome(r.queue));
    }

    public Option<SendToRejected> asMoveToAnotherRejected(Option<Queue> sourceQueue) {
        return asSendToRejected().filter(r -> !sourceQueue.isSome(r.queue));
    }

    public static class Done extends BazingaReaction {
    }

    public static class SendToExecution extends BazingaReaction {
        public final RoutedJob job;

        public SendToExecution(RoutedJob job) {
            this.job = job;
        }
    }

    public static class SendToExecutionOrRestoreReady extends SendToExecution {
        public SendToExecutionOrRestoreReady(RoutedJob job) {
            super(job);
        }
    }

    public static class SendToRejected extends BazingaReaction {
        public final Queue queue;

        public SendToRejected(Queue queue) {
            this.queue = queue;
        }
    }
}
