package ru.yandex.chemodan.app.queller.celery.routing;

import org.springframework.amqp.core.Message;
import org.springframework.amqp.support.converter.MessageConversionException;

import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.queller.celery.job.CeleryJob;
import ru.yandex.chemodan.queller.rabbit.patchedSpringAmqp.BatchMessageListener;
import ru.yandex.chemodan.queller.support.BenderJsonMessageConverter;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author dbrylev
 */
public class JobsListenerAdapter implements BatchMessageListener {

    private static final Logger logger = LoggerFactory.getLogger(JobsListenerAdapter.class);

    private static final BenderJsonMessageConverter<CeleryJob> converter =
            new BenderJsonMessageConverter<>(CeleryJob.class);

    private final Function<ListF<CeleryJob>, ListF<Boolean>> listener;

    public JobsListenerAdapter(Function<ListF<CeleryJob>, ListF<Boolean>> listener) {
        this.listener = listener;
    }

    @Override
    public final ListF<Boolean> onMessages(ListF<Message> messages) {
        ListF<Option<CeleryJob>> converted = messages.map(m -> {
            try {
                return Option.of(converter.fromMessage(m));

            } catch (MessageConversionException t) {
                logger.warn("Message conversion error occurred; message will be dropped: {}", m, t);
                return Option.empty();
            }
        });
        IteratorF<Boolean> result = listener.apply(converted.flatMap(o -> o)).iterator();

        return converted.map(o -> !o.isPresent() || result.next());
    }
}
