package ru.yandex.chemodan.app.queller.celery.settings.monitor;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.queller.celery.settings.worker.WorkerAssignmentRulesManager;
import ru.yandex.chemodan.queller.celery.control.CeleryControl;
import ru.yandex.chemodan.queller.celery.monitoring.CeleryMetrics;
import ru.yandex.chemodan.queller.celery.worker.WorkerStateProviderHolder;
import ru.yandex.chemodan.queller.rabbit.RabbitPool;
import ru.yandex.misc.spring.ApplicationContextUtils;

/**
 * @author yashunsky
 */

@Configuration
public class CeleryMonitorContextConfiguration {
    @Bean
    public CeleryMonitor celeryMonitor(
            RabbitPool rabbitPool,
            CeleryControl celery,
            WorkerAssignmentRulesManager workerManager,
            @Value("${queller.celery.maintenancePeriod}") Duration maintenancePeriod,
            CeleryMetrics metrics, ApplicationContext context)
    {
        CeleryMonitor monitor = new CeleryMonitor(rabbitPool, celery, workerManager, maintenancePeriod, metrics);

        ApplicationContextUtils.beansOfType(context, WorkerStateProviderHolder.class).forEach(h -> h.setProvider(monitor));
        return monitor;
    }
}
