package ru.yandex.chemodan.app.queller.celery.settings.monitor;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.queller.celery.worker.WorkerId;
import ru.yandex.misc.ip.Host;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
public class RabbitsWorkersTest {

    @Test
    public void balancingAssignments() {
        Function<Tuple2List<String, ListF<String>>, Tuple2List<String, String>> balance = rabbitsWorkers -> {
            ListF<Host> rabbits = rabbitsWorkers.get1().map(Host::parse);

            ListF<RabbitsWorkers.RabbitWorker> rabbitWorkers =
                    rabbitsWorkers.flatMap(ws -> ws.get2().map(
                            w -> new RabbitsWorkers.RabbitWorker(Host.parse(ws.get1()), WorkerId.parse("w@" + w))));

            RabbitsWorkers workers = new RabbitsWorkers(rabbits, rabbitWorkers);

            return workers.balancingAssignments().map1(w -> w.host.get().format()).map2(Host::format);
        };

        Assert.equals(
                Tuple2List.tuple2List(), balance.apply(Tuple2List.tuple2List()));

        Assert.equals(
                Tuple2List.tuple2List(),
                balance.apply(Tuple2List.fromPairs("rabbit1", Cf.list("worker1", "worker2"))));

        Assert.equals(
                Tuple2List.tuple2List(),
                balance.apply(Tuple2List.fromPairs("rabbit1", Cf.list("worker1"), "rabbit2", Cf.list())));

        Assert.equals(
                Tuple2List.fromPairs("worker2", "rabbit2"),
                balance.apply(Tuple2List.fromPairs(
                        "rabbit1", Cf.list("worker1", "worker2"),
                        "rabbit2", Cf.list())));

        Assert.equals(
                Tuple2List.fromPairs("worker5", "rabbit1", "worker4", "rabbit1"),
                balance.apply(Tuple2List.fromPairs(
                        "rabbit1", Cf.list(),
                        "rabbit2", Cf.list("worker1", "worker2", "worker3", "worker4", "worker5"))));

        Assert.equals(
                Tuple2List.fromPairs(
                        "workerC", "rabbit1", "worker9", "rabbit3", "workerB", "rabbit1", "worker8", "rabbit3"),
                balance.apply(Tuple2List.fromPairs(
                        "rabbit1", Cf.list(),
                        "rabbit2", Cf.list("worker1", "worker2", "worker3", "worker7", "worker8", "worker9"),
                        "rabbit3", Cf.list(),
                        "rabbit4", Cf.list("worker4", "worker5", "worker6", "workerA", "workerB", "workerC"))));
    }
}
