package ru.yandex.chemodan.app.queller.celery.settings.queue;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.bazinga.BazingaBender;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;

/**
 * @author dbrylev
 */
public class CeleryQueueSettingsRegistry extends ZkRegistry<String, CeleryQueueSettings> {

    private static final String DEFAULTS_NAME = "defaults";
    private static final int DEFAULT_FROM_LOCAL_LIMIT = 50000;
    private static final int DEFAULT_FROM_GLOBAL_LIMIT = 30000;

    public CeleryQueueSettingsRegistry(ZkPath path) {
        super(path, BazingaBender.mapper.createParserSerializer(CeleryQueueSettings.class), q -> q.name, s -> s);
    }

    public CeleryQueueSettings getDefaults() {
        return getO(DEFAULTS_NAME)
                .getOrElse(() -> new CeleryQueueSettings(
                        DEFAULTS_NAME,
                        DEFAULT_FROM_LOCAL_LIMIT,
                        DEFAULT_FROM_GLOBAL_LIMIT));
    }

    public CeleryQueueSettings getOrDefault(String queueName) {
        Option<CeleryQueueSettings> found = getO(queueName);

        if (found.isPresent()) return found.get();

        CeleryQueueSettings defaults = getDefaults();
        return new CeleryQueueSettings(queueName,
                defaults.enqueueFromLocalLengthLimit,
                defaults.enqueueFromGlobalLengthLimit);
    }

    public ListF<CeleryQueueSettings> getAllNonDefaults() {
        return getAll().iterator().filter(s -> !s.name.equals(DEFAULTS_NAME)).toList();
    }
}
