package ru.yandex.chemodan.app.queller.celery.settings.worker;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.commune.alive2.location.LocationResolver;
import ru.yandex.commune.alive2.location.LocationResolverConfiguration;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author dbrylev
 */
@Configuration
@Import(LocationResolverConfiguration.class)
public class CeleryWorkerSettingsContextConfiguration {

    @Bean
    public WorkerAssignmentRulesManager workerAssignmentRulesManager(
            @Qualifier("zkRoot") ZkPath zkRoot,
            ZkManager zkManager, LocationResolver locationResolver)
    {
        WorkerAssignmentRulesManager manager = new WorkerAssignmentRulesManager(
                zkRoot.child("celery-worker-rules"),
                zkRoot.child("celery-denied-queues"), locationResolver);
        zkManager.addClient(manager);

        return manager;
    }
}
