package ru.yandex.chemodan.app.queller.celery.settings.worker.rules;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.alive2.location.Location;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderIgnore;
import ru.yandex.misc.bender.annotation.BenderParseSubclasses;
import ru.yandex.misc.bender.annotation.SubclassTypeDefinition;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author dbrylev
 */
@BenderBindAllFields
@BenderParseSubclasses(
        value = {
                RuleScope.Global.class,
                RuleScope.Dc.class,
                RuleScope.Host.class,
        },
        typeDefinition = SubclassTypeDefinition.FIELD,
        jsonFieldName = "type"
)
public abstract class RuleScope {
    public abstract boolean matches(Location location);
    public abstract int priority();

    public void validate() {}

    @BenderBindAllFields
    public static class Global extends RuleScope {
        @Override
        public boolean matches(Location location) {
            return true;
        }

        @Override
        public int priority() {
            return 0;
        }
    }

    @BenderBindAllFields
    public static class Dc extends RuleScope {
        public final ListF<String> names;

        public Dc(ListF<String> names) {
            this.names = names;
        }

        @Override
        public boolean matches(Location location) {
            return names.containsTs(location.dcName.getOrNull());
        }

        @Override
        public int priority() {
            return 1;
        }
    }

    @BenderBindAllFields
    public static class Host extends RuleScope {
        public final String regex;
        @BenderIgnore
        public transient Pattern2 pattern;

        public Host(String regex) {
            this.regex = regex;
        }

        @Override
        public boolean matches(Location location) {
            if (pattern == null) {
                pattern = Pattern2.compile(regex);
            }
            return pattern.matches(location.host);
        }

        @Override
        public int priority() {
            return 4;
        }

        @Override
        public void validate() {
            Pattern2.compile(regex);
        }
    }
}
