package ru.yandex.chemodan.app.queller.web;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.queller.celery.routing.CeleryTasksDirector;
import ru.yandex.chemodan.queller.celery.job.CeleryJob;
import ru.yandex.chemodan.util.exception.A3ExceptionWithNoStackTrace;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.parameter.bind.BoundByBender;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

/**
 * @author dbrylev
 */
@ActionContainer
public class QuellerActions {

    private final CeleryTasksDirector celeryTasksDirector;

    public QuellerActions(CeleryTasksDirector celeryTasksDirector) {
        this.celeryTasksDirector = celeryTasksDirector;
    }

    @Action
    public OkPojo submitJob(
            @RequestParam("startExecutionImmediately") Option<Boolean> executeImmediately,
            @BoundByBender CeleryJob job)
    {
        if (!celeryTasksDirector.handleSubmit(Cf.list(job), Option.empty(), executeImmediately.isSome(true)).single()) {
            throw new A3ExceptionWithNoStackTrace("nack", "Job submission was not succeeded: " + job.forLog()) {};
        }
        return new OkPojo();
    }
}
