package ru.yandex.chemodan.app.queller.web;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.queller.celery.routing.CeleryTasksDirector;
import ru.yandex.chemodan.bazinga.http.PgTasksActionContainer;
import ru.yandex.chemodan.boot.ChemodanActionAppConfigurator;
import ru.yandex.chemodan.core.worker.python.onetime.ConfigurableOnetimeTaskRegistry;
import ru.yandex.chemodan.queller.celery.CeleryBender;
import ru.yandex.chemodan.util.web.A3JettyConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.bazinga.pg.PgBazingaTaskManager;
import ru.yandex.commune.bazinga.pg.context.PgBazingaClientContextConfiguration;
import ru.yandex.commune.bazinga.pg.storage.PgBazingaStorage;

/**
 * @author dbrylev
 */
@Import({
        A3JettyContextConfiguration.class,
        PgBazingaClientContextConfiguration.class
})
public class QuellerActionsContextConfiguration {

    @Bean
    public A3JettyConfiguration a3JettyServletsConfiguration() {
        return new A3JettyConfiguration(Tuple2List.fromPairs(
                "/api/*", "",
                "/tasks/*", ""
        ));
    }

    @Bean
    public ActionApp actionApp(ApplicationContext context, ApplicationInfo applicationInfo) {
        return ChemodanActionAppConfigurator.cons(applicationInfo, context)
                .addJsonBending(CeleryBender.mapper)
                .configure();
    }

    @Bean
    public QuellerActions quellerActions(CeleryTasksDirector celeryTasksDirector) {
        return new QuellerActions(celeryTasksDirector);
    }

    @Bean
    public ConfigurableOnetimeTaskRegistry configurableOnetimeTaskRegistry() {
        return new ConfigurableOnetimeTaskRegistry();
    }

    @Bean
    public PgTasksActionContainer pgTasksActionContainer(
            ConfigurableOnetimeTaskRegistry configurableOnetimeTaskRegistry,
            PgBazingaStorage storage,
            PgBazingaTaskManager taskManager,
            @Value("${queller.task.bulk-add.pool-size}") int poolSize) {
        return new PgTasksActionContainer(configurableOnetimeTaskRegistry, storage, taskManager, poolSize);
    }
}
