package ru.yandex.chemodan.app.smartcache.client;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.smartcache.client.actions.GetSmartCacheDeltaListAction;
import ru.yandex.chemodan.app.smartcache.client.actions.GetSmartCacheLastRevSnapshotAction;
import ru.yandex.chemodan.app.smartcache.client.actions.GetSmartCacheSnapshotAction;
import ru.yandex.chemodan.app.smartcache.client.actions.PhotosliceInitAction;
import ru.yandex.chemodan.app.smartcache.client.http.SmartcacheWorkerHttpProxy;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.DataApiStorageManager;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.DataApiStorageManagerContextConfiguration;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.cleanup.CleanupManager;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;

/**
 * @author osidorkin
 */
@Configuration
@Import({
    DataApiStorageManagerContextConfiguration.class,
})
public class SmartCacheClientActionContextConfiguration {
    @Value("${smartcache.worker.url:-}")
    private String workerUrl;

    @Bean
    public GetSmartCacheSnapshotAction getSmartCacheSnapshotAction(DataApiStorageManager dataApiStorageManager,
            CleanupManager cleanupManager)
    {
        return new GetSmartCacheSnapshotAction(dataApiStorageManager, cleanupManager);
    }

    @Bean
    public GetSmartCacheLastRevSnapshotAction getSmartCacheLastRevSnapshotAction(DataApiStorageManager dataApiStorageManager) {
        return new GetSmartCacheLastRevSnapshotAction(dataApiStorageManager);
    }

    @Bean
    public GetSmartCacheDeltaListAction getSmartCacheDeltaListAction(DataApiStorageManager dataApiStorageManager,
            CleanupManager cleanupManager)
    {
        return new GetSmartCacheDeltaListAction(dataApiStorageManager, cleanupManager);
    }

    @Bean
    public PhotosliceInitAction photosliceInitAction(DataApiStorageManager dataApiStorageManager,
            SmartcacheWorkerHttpProxy smartcacheWorkerHttpProxy, MpfsClient mpfsClient)
    {
        return new PhotosliceInitAction(dataApiStorageManager, smartcacheWorkerHttpProxy, mpfsClient);
    }

    @Bean
    public SmartcacheWorkerHttpProxy smartcacheWorkerHttpProxy() {
        return new SmartcacheWorkerHttpProxy(smartcacheWorkerHttpClientConfigurator().configure(), workerUrl);
    }

    @Bean
    @OverridableValuePrefix("smartcache_worker")
    public HttpClientConfigurator smartcacheWorkerHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

}
