package ru.yandex.chemodan.app.smartcache.client;

import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.dataapi.web.DeltaParameterBinder;
import ru.yandex.chemodan.app.smartcache.NS;
import ru.yandex.chemodan.app.smartcache.worker.SmartCacheCommonAppContextConfiugration;
import ru.yandex.chemodan.app.smartcache.worker.SmartCacheDynamicPropertiesContextConfiguration;
import ru.yandex.chemodan.app.smartcache.worker.utils.PhotoViewCacheBender;
import ru.yandex.chemodan.boot.ChemodanActionAppConfigurator;
import ru.yandex.chemodan.util.web.A3JettyConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.action.result.AddCommonAttributesInterceptor;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.ProtobufResultSerializer;
import ru.yandex.misc.bender.BenderMapper;

/**
 * @author osidorkin
 */
@Configuration
@Import({
    SmartCacheCommonAppContextConfiugration.class,
    SmartCacheClientActionContextConfiguration.class,
    SmartCacheDynamicPropertiesContextConfiguration.class,
    A3JettyContextConfiguration.class
})
public class SmartCacheClientDaemonContextConfiguration {

    @Bean
    public A3JettyConfiguration a3JettyServletsConfiguration() {
        return new A3JettyConfiguration(Tuple2List.fromPairs(
                "/smartcache/*", NS.SMARTCACHE
        ));
    }

    @Bean
    public ActionApp actionApp(
            ApplicationContext context,
            ApplicationInfo applicationInfo)
    {
        BenderMapper benderMapper = PhotoViewCacheBender.clientA3Mapper();

        ChemodanActionAppConfigurator configurator = ChemodanActionAppConfigurator.cons(applicationInfo, context);

        configurator
                .addJsonBending(benderMapper).getBuilder()

                .addResultSerializers(Cf.list(
                        new ProtobufResultSerializer()))

                .addParameterBinders(Cf.list(
                        new DeltaParameterBinder(benderMapper)))

                .addInvocationInterceptor(new AddCommonAttributesInterceptor(applicationInfo));

        return configurator.configure();
    }
}
