package ru.yandex.chemodan.app.smartcache.client;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.DataApiBaseContextConfiguration;
import ru.yandex.chemodan.app.smartcache.admin.SmartCacheAdminContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.misc.db.monica.JdbcMetricsSwitch;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author osidorkin
 */
public class SmartCacheClientMain extends ChemodanMainSupport {

    public static void main(String[] args) {
        JdbcMetricsSwitch.ENABLED = true;
        JdbcMetricsSwitch.COMMAND_METRICS_ENABLED = true;
        new SmartCacheClientMain().runMain(args);
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("disk", "smartcache-client");
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(ChemodanCommonContextConfiguration.class,
                SmartCacheClientDaemonContextConfiguration.class,
                DataApiBaseContextConfiguration.class,
                SmartCacheAdminContextConfiguration.class);
    }
}
