package ru.yandex.chemodan.app.smartcache.client.actions;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.collection.Try;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.ClusterId;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.mappers.AlbumsToDeltaMapper;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.mappers.IndexToDeltaMapper;

/**
 * @author dbrylev
 */
public class CollectionIdsResolver {

    public static SetF<String> resolve(ListF<String> clusterIds) {
        SetF<String> result = Cf.hashSetWithExpectedSize(clusterIds.size() * 2);

        clusterIds.forEach(clusterId -> {
            if (clusterId.equals(IndexToDeltaMapper.INDEX_COLLECTION_ID) ||
                    clusterId.equals(AlbumsToDeltaMapper.ALBUMS_COLLECTION_ID))
            {
                result.add(clusterId);

            } else {
                Try<ClusterId> parsed = Try.tryCatchException(() -> ClusterId.parse(clusterId));

                if (parsed.isSuccess()) {
                    result.addAll(parsed.toOption().flatMap(ClusterId::formatAll));

                } else {
                    result.add(clusterId);
                }
            }
        });
        return result;
    }
}
