package ru.yandex.chemodan.app.smartcache.client.actions;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
public class CollectionIdsResolverTest {

    @Test
    public void resolve() {
        Assert.equals(Cf.set(), CollectionIdsResolver.resolve(Cf.list()));

        Assert.equals(Cf.set("_index", "XXX"), CollectionIdsResolver.resolve(Cf.list("_index", "XXX")));

        Assert.equals(
                CollectionIdsResolver.resolve(Cf.list("19700101000001000Z_19700101000002000Z")),
                CollectionIdsResolver.resolve(Cf.list("0000000000000001000_0000000000000002000")));

        Assert.equals(
                Cf.set("19700101000001000Z_19700101000002000Z", "0000000000000001000_0000000000000002000"),
                CollectionIdsResolver.resolve(Cf.list("0000000000000001000_0000000000000002000")));
    }
}
