package ru.yandex.chemodan.app.smartcache.client.actions;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.web.DeltasGoneException;
import ru.yandex.chemodan.app.dataapi.web.NotFoundException;
import ru.yandex.chemodan.app.dataapi.web.convert.ConvertToDataapiUser;
import ru.yandex.chemodan.app.smartcache.AlbumsUtils;
import ru.yandex.chemodan.app.smartcache.NS;
import ru.yandex.chemodan.app.smartcache.client.actions.pojo.DeltaListResponsePojo;
import ru.yandex.chemodan.app.smartcache.client.actions.pojo.ResponsePojoMappers;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.DataApiStorageManager;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.cleanup.CleanupManager;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;
import ru.yandex.misc.lang.Validate;

/**
 * @author osidorkin
 */
@Action(
        value = @Action.Alias(value = "get-smartcache-deltas-list", namespace = NS.SMARTCACHE),
        description = "Получить список изменений начиная с некоторой ревизии")
@Path(value = "/smartcache-deltas-list", methods = HttpMethod.GET)
@WithMasterSlavePolicy(MasterSlavePolicy.R_MS)
public class GetSmartCacheDeltaListAction extends PublicCloneableActionSupport {

    @RequestParam(value = "__uid", customConverter = ConvertToDataapiUser.class)
    private DataApiUserId user;
    @RequestParam
    private String photosliceId;
    @RequestParam
    private long rev;
    @RequestParam(required = false)
    private int limit = 100;
    @RequestParam
    private Option<String> collectionId;

    private final DataApiStorageManager dataApiStorageManager;
    private final CleanupManager cleanupManager;

    public GetSmartCacheDeltaListAction(DataApiStorageManager dataApiStorageManager, CleanupManager cleanupManager) {
        this.dataApiStorageManager = dataApiStorageManager;
        this.cleanupManager = cleanupManager;
    }

    @Override
    public DeltaListResponsePojo execute() throws Exception {
        Validate.isTrue(limit >= 0);
        Validate.isTrue(rev >= 0);

        Option<Database> databaseO = dataApiStorageManager.getDatabaseByHandleO(user, photosliceId);
        if (!databaseO.isPresent()) {
            throw new NotFoundException("Snapshot not found");
        }
        Database database = databaseO.get();
        try {
            ListF<Delta> deltas = dataApiStorageManager.getDeltasList(
                    user, photosliceId, rev, database.rev, CollectionIdsResolver.resolve(collectionId), limit);

            cleanupManager.revisionRetrieved(user, photosliceId, database.rev);
            cleanupManager.deltaRetrieved(user, database.handleValue(), rev, database.rev);

            if (deltas.isEmpty()) {
                return ResponsePojoMappers.deltaListResponseEmptyPojo(rev);
            }
            return ResponsePojoMappers.deltaListResponsePojo(deltas, database.rev, AlbumsUtils.isWithAlbums(database));
        } catch (DeltasGoneException e) {
            throw new NotFoundException("Delta not found");
        }
    }
}
