package ru.yandex.chemodan.app.smartcache.client.actions;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotWithSource;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.web.NotFoundException;
import ru.yandex.chemodan.app.dataapi.web.convert.ConvertToDataapiUser;
import ru.yandex.chemodan.app.smartcache.NS;
import ru.yandex.chemodan.app.smartcache.client.actions.pojo.ResponsePojoMappers;
import ru.yandex.chemodan.app.smartcache.client.actions.pojo.SnapshotResponsePojo;
import ru.yandex.chemodan.app.smartcache.worker.clusterizer.ClusterizationType;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.DataApiStorageManager;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.mappers.AlbumsToDeltaMapper;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.mappers.IndexToDeltaMapper;
import ru.yandex.chemodan.app.smartcache.worker.utils.SqlLimitsHelper;
import ru.yandex.chemodan.log.utils.ExtraRequestLogFieldsUtil;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestListParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.SpecialParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;
import ru.yandex.misc.db.q.SqlLimits;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author osidorkin
 */
@Action(
        value = @Action.Alias(value = "get-smartcache-snapshot-last", namespace = NS.SMARTCACHE),
        description = "Получить последнюю версию снапшота базы")
@Path(value = "/smartcache-snapshot-last", methods = HttpMethod.GET)
public class GetSmartCacheLastRevSnapshotAction extends PublicCloneableActionSupport {

    @RequestParam(value = "__uid", customConverter = ConvertToDataapiUser.class)
    private DataApiUserId user;
    @RequestParam
    private String photosliceId;
    @RequestListParam(value = "clusterIds", required = false)
    private ListF<String> clusterIds;
    @RequestListParam(value = "fields", required = false)
    private ListF<String> fields;
    @RequestParam
    private Option<Integer> offset;
    @RequestParam
    private Option<Integer> limit;

    @SpecialParam
    private HttpServletRequestX request;

    private final DataApiStorageManager dataApiStorageManager;


    public GetSmartCacheLastRevSnapshotAction(DataApiStorageManager dataApiStorageManager) {
        this.dataApiStorageManager = dataApiStorageManager;
    }

    @Override
    public SnapshotResponsePojo execute() {
        SqlLimits limits = SqlLimitsHelper.getLimits(limit, offset);

        Option<SetF<String>> clusterIdsO = Option.when(clusterIds.isNotEmpty(),
                () -> CollectionIdsResolver.resolve(clusterIds).plus(IndexToDeltaMapper.INDEX_COLLECTION_ID)
                        .plus(AlbumsToDeltaMapper.ALBUMS_COLLECTION_ID));

        Option<Database> databaseO = dataApiStorageManager.getDatabaseO(user);
        if (!databaseO.isPresent()) {
            throw new NotFoundException("Database not found");
        }

        SnapshotWithSource snapshot =
                dataApiStorageManager.getSnapshotO(user, photosliceId, databaseO.get().rev, clusterIdsO, limits)
                        .getOrThrow(() -> new NotFoundException("Snapshot not found"));

        ExtraRequestLogFieldsUtil.addField(request, "snapshot_source", snapshot.getSource());
        return ResponsePojoMappers.snapshotResponsePojo(ClusterizationType.GEO, photosliceId, snapshot.getSnapshot());
    }
}
