package ru.yandex.chemodan.app.smartcache.client.actions;

import org.apache.http.HttpResponse;
import org.joda.time.Instant;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.chemodan.app.dataapi.core.mdssnapshot.MdsSnapshotReference;
import ru.yandex.chemodan.app.dataapi.core.mdssnapshot.MdsSnapshotReferenceJdbcDao;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.DataApiStorageManager;
import ru.yandex.chemodan.test.A3TestSupport;
import ru.yandex.misc.test.Assert;

import static ru.yandex.chemodan.app.dataapi.core.dao.test.ActivateDataApiEmbeddedPg.DATAAPI_EMBEDDED_PG;
import static ru.yandex.misc.db.embedded.ActivateEmbeddedPg.EMBEDDED_PG;


/**
 * @author friendlyevil
 */
@ContextConfiguration(classes = SmartCacheTestConfiguration.class)
@ActiveProfiles({EMBEDDED_PG, DATAAPI_EMBEDDED_PG})
public class GetSmartCacheSnapshotActionTest extends A3TestSupport {

    @Autowired
    private DataApiStorageManager dataApiStorageManager;
    @Autowired
    private MdsSnapshotReferenceJdbcDao mdsSnapshotReferenceJdbcDao;

    @Test
    public void testDeleteFromMdsInReadTransaction() {
        DataApiPassportUserId uid = new DataApiPassportUserId(1);
        dataApiStorageManager.createDatabase(uid);
        Database database = dataApiStorageManager.getDatabase(uid);
        String handle = database.handleValue();

        mdsSnapshotReferenceJdbcDao.insert(new MdsSnapshotReference(handle, 1,
                Instant.now(), Option.of("346/error"), uid));

        Assert.assertTrue(mdsSnapshotReferenceJdbcDao.find(uid, handle, 1).isPresent());

        HttpResponse httpResponse = get("/smartcache/smartcache-snapshot?__uid=1&photoslice-id=" + handle +
                "&fields=clusters.items&rev=1");

        Assert.assertEquals(httpResponse.getStatusLine().getStatusCode(), 404);
        Assert.assertFalse(mdsSnapshotReferenceJdbcDao.find(uid, handle, 1).isPresent());
    }
}
