package ru.yandex.chemodan.app.smartcache.client.actions;

import org.springframework.jdbc.UncategorizedSQLException;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.web.convert.ConvertToDataapiUser;
import ru.yandex.chemodan.app.smartcache.NS;
import ru.yandex.chemodan.app.smartcache.client.http.SmartcacheWorkerHttpProxy;
import ru.yandex.chemodan.app.smartcache.worker.actions.InitActionResponsePojo;
import ru.yandex.chemodan.app.smartcache.worker.clusterizer.ClusterizationType;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.DataApiStorageManager;
import ru.yandex.chemodan.app.smartcache.worker.utils.DynamicVars;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author osidorkin
 */
@Action(
        value = @Action.Alias(value = "get-init-snapshot", namespace = NS.SMARTCACHE),
        description = "Получить снапшот базы или создать на воркере, если не было")
@Path(value = "/photoslice-init-snapshot", methods = HttpMethod.GET)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class PhotosliceInitAction extends PublicCloneableActionSupport {

    private final Logger logger = LoggerFactory.getLogger(PhotosliceInitAction.class);

    @RequestParam(value = "__uid", customConverter = ConvertToDataapiUser.class)
    private DataApiUserId user;
    @RequestParam
    private Option<ClusterizationType> clusterizationType;

    private DataApiStorageManager dataApiStorageManager;
    private SmartcacheWorkerHttpProxy smartcacheWorkerHttpProxy;
    private MpfsClient mpfsClient;

    public PhotosliceInitAction(DataApiStorageManager dataApiStorageManager,
            SmartcacheWorkerHttpProxy smartcacheWorkerHttpProxy, MpfsClient mpfsClient)
    {
        this.dataApiStorageManager = dataApiStorageManager;
        this.smartcacheWorkerHttpProxy = smartcacheWorkerHttpProxy;
        this.mpfsClient = mpfsClient;
    }

    @Override
    public InitActionResponsePojo execute() throws Exception {
        boolean albumsEnabled = DynamicVars.photosliceCreateWithAlbums.get() || (DynamicVars.useMpfsAlbumsFlag.get()
                && mpfsClient.arePhotosliceAlbumsEnabledSafe(user.forMpfs()));
        try {
            Option<Database> databaseO = dataApiStorageManager.getIfAlbumsEnoughAndInitCopyOnWrite(user, albumsEnabled);
            if (databaseO.isPresent()) {
                return InitActionResponsePojo.cons(databaseO.get());
            }
        } catch (UncategorizedSQLException e) {
            logger.error("Couldn't get and init snapshot for user: {}", user, e);
            Option<Database> databaseO = dataApiStorageManager.getDatabaseIfAlbumsEnough(user, albumsEnabled);
            if (databaseO.isPresent()) {
                return InitActionResponsePojo.cons(databaseO.get());
            }
        }
        return smartcacheWorkerHttpProxy.initSnapshotOnWorker(user, albumsEnabled);
    }
}
