package ru.yandex.chemodan.app.smartcache.client.actions;

import java.io.IOException;
import java.util.Arrays;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange.FieldChangeType;
import ru.yandex.chemodan.app.smartcache.client.actions.pojo.DeltaLocalityChangePojo;
import ru.yandex.chemodan.app.smartcache.worker.tests.TestUtils;
import ru.yandex.chemodan.app.smartcache.worker.utils.PhotoViewCacheBender;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.test.Assert;

/**
 * @author osidorkin
 */
public class PojoSerializationTest {

    @Test
    public void deltaLocalityChangePojo() throws IOException {
        BenderMapper benderMapper = PhotoViewCacheBender.clientA3Mapper();
        BenderParserSerializer<DeltaLocalityChangePojo> deltaLocalityChangeParserSerializer =
                benderMapper.createParserSerializer(DeltaLocalityChangePojo.class);

        DeltaLocalityChangePojo pojo = new DeltaLocalityChangePojo(FieldChangeType.PUT,
                Option.of(TestUtils.createLocalizedStringDictionary("City").toMap()));

        byte[] serialized = deltaLocalityChangeParserSerializer.getSerializer().serializeJson(pojo);
        String etalon = "{\"change_type\":\"insert\",\"data\":{\"en\":\"City\","
            + "\"ru\":\"City\",\"uk\":\"City\",\"tr\":\"City\"}}";
        Assert.isTrue(Arrays.equals(etalon.getBytes(), serialized));
        DeltaLocalityChangePojo newPojo = deltaLocalityChangeParserSerializer.getParser().parseJson(etalon);
        Assert.equals(pojo.changeType, newPojo.changeType);
        Assert.equals(pojo.data, newPojo.data);
    }
}
