package ru.yandex.chemodan.app.smartcache.client.actions;

import org.mockito.Mockito;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.dataapi.apps.profile.address.AddressManager;
import ru.yandex.chemodan.app.dataapi.core.dao.test.ActivateDataApiEmbeddedPg;
import ru.yandex.chemodan.app.smartcache.client.SmartCacheClientDaemonContextConfiguration;
import ru.yandex.chemodan.app.smartcache.worker.tests.TestsContextConfiguration;
import ru.yandex.chemodan.zk.configuration.ImportZkEmbeddedConfiguration;
import ru.yandex.commune.dynproperties.DynamicPropertyRegistry;

/**
 * @author friendlyevil
 */
@Configuration
@ActivateDataApiEmbeddedPg
@ImportZkEmbeddedConfiguration
@Import({
        SmartCacheClientDaemonContextConfiguration.class,
        TestsContextConfiguration.class
})
public class SmartCacheTestConfiguration {

    @Bean
    public DynamicPropertyRegistry dynamicPropertyRegistry() {
        return Mockito.mock(DynamicPropertyRegistry.class);
    }

    @Bean
    public AddressManager addressManager() {
        return Mockito.mock(AddressManager.class);
    }
}
