package ru.yandex.chemodan.app.smartcache.client.actions.pojo;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.smartcache.worker.clusterizer.pojo.AlbumType;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.mappers.AlbumsToDeltaMapper;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author yashunsky
 */
@BenderBindAllFields
public class DeltaAlbumCounterChangePojo {
    public final AlbumType album;
    @BenderPart(name = "change_type", strictName = true)
    public final PojoFieldChangeType changeType;
    public final Option<Integer> count;

    public DeltaAlbumCounterChangePojo(AlbumType album, FieldChange.FieldChangeType changeType, Option<Integer> count) {
        this.album = album;
        this.changeType = PojoFieldChangeType.fromFieldChangeType(changeType);
        this.count = count;
    }

    public static DeltaAlbumCounterChangePojo consFromChange(FieldChange fieldChange) {
        AlbumType album = AlbumsToDeltaMapper.parseAlbumTypeFromField(fieldChange.key);
        Option<Integer> countO = Option.when(
                fieldChange.type != FieldChange.FieldChangeType.DELETE,
                () -> fieldChange.getValue().integerValue().intValue());
        return new DeltaAlbumCounterChangePojo(album, fieldChange.type, countO);
    }
}
