package ru.yandex.chemodan.app.smartcache.client.actions.pojo;

import lombok.AllArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author osidorkin
 */
@AllArgsConstructor
@BenderBindAllFields
public class DeltaIndexFieldChangePojo {
    @BenderPart(name = "items_count", strictName = true)
    public final Option<Long> itemsCount;
    public final Option<Instant> from;
    public final Option<Instant> to;
    public final Option<DeltaLocalityChangePojo> locality;
    public final Option<ListF<DeltaPlacesListChangePojo>> places;
    public final Option<ListF<DeltaAlbumCounterChangePojo>> albums;
}
