package ru.yandex.chemodan.app.smartcache.client.actions.pojo;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange.FieldChangeType;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.mappers.IndexToDeltaMapper;
import ru.yandex.inside.utils.Language;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author osidorkin
 */
@BenderBindAllFields
public class DeltaLocalityChangePojo {
    @BenderPart(name = "change_type", strictName = true)
    public final PojoFieldChangeType changeType;
    public final Option<MapF<Language, String>> data;
    public DeltaLocalityChangePojo(FieldChangeType changeType, Option<MapF<Language, String>> data) {
        this.changeType = PojoFieldChangeType.fromFieldChangeType(changeType);
        this.data = data;
    }

    public static DeltaLocalityChangePojo consFromChange(FieldChange fieldChange) {
        Option<MapF<Language, String>> resourcesO = Option.when(
                fieldChange.type != FieldChangeType.DELETE,
                () -> IndexToDeltaMapper.fieldToLocalizedStringDictionary(fieldChange.getValue()).toMap());
        return new DeltaLocalityChangePojo(fieldChange.type, resourcesO);
    }
}
