package ru.yandex.chemodan.app.smartcache.client.actions.pojo;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange.FieldChangeType;
import ru.yandex.inside.utils.Language;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author osidorkin
 */
@BenderBindAllFields
public class DeltaPlacesListChangePojo {
    @BenderPart(name = "change_type", strictName = true)
    public final PojoFieldChangeType changeType;
    @BenderPart(name = "place_index", strictName = true)
    public final int placeIndex;
    public final Option<MapF<Language, String>> data;

    public DeltaPlacesListChangePojo(FieldChangeType changeType, int placeIndex, Option<MapF<Language, String>> data) {
        this.changeType = PojoFieldChangeType.fromFieldChangeType(changeType);
        this.placeIndex = placeIndex;
        this.data = data;
    }
}
