package ru.yandex.chemodan.app.smartcache.client.actions.pojo;

import lombok.AllArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.smartcache.worker.clusterizer.pojo.AlbumType;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.DisplayedCluster;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.LocalizedStringDictionary;
import ru.yandex.inside.utils.Language;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author osidorkin
 */
@AllArgsConstructor
@BenderBindAllFields
public class SnapshotIndexItemPojo {
    @BenderPart(name = "cluster_id", strictName = true)
    public final String clusterId;
    @BenderPart(name = "items_count", strictName = true)
    public final int itemsCount;
    public final Instant from;
    public final Instant to;
    public final Option<MapF<Language, String>> locality;
    public final Option<ListF<MapF<Language, String>>> places;
    public final MapF<AlbumType, Integer> albums;

    public static SnapshotIndexItemPojo cons(DisplayedCluster displayedCluster) {
        ListF<MapF<Language, String>> places = displayedCluster.getPlaces().map(LocalizedStringDictionary::toMap);
        return new SnapshotIndexItemPojo(
                displayedCluster.getId().formatForView(), displayedCluster.getPhotosCount(),
                displayedCluster.getFrom(), displayedCluster.getTo(),
                displayedCluster.getLocalityO().map(LocalizedStringDictionary::toMap),
                Option.when(places.isNotEmpty(), places),
                displayedCluster.getAlbumsEntries());
    }
}
