package ru.yandex.chemodan.app.smartcache.client.actions.pojo;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.smartcache.worker.clusterizer.ClusterizationType;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author osidorkin
 */
@ActionResultPojo
@BenderBindAllFields
public class SnapshotResponsePojo {
    @BenderPart(name = "clusterization_type", strictName = true)
    public final ClusterizationType clusterizationType;
    @BenderPart(name = "photoslice_id", strictName = true)
    public final String handle;
    @BenderPart(name = "revision", strictName = true)
    public final long rev;
    public final Option<SnapshotIndexItemPojoHolder> index;
    public final Option<SnapshotClusterPojoHolder> clusters;
    public final Option<SnapshotAlbumsPojoHolder> albums;

    public SnapshotResponsePojo(ClusterizationType clusterizationType, String handle, long rev,
            Option<ListF<SnapshotIndexItemPojo>> index, Option<ListF<SnapshotClusterPojo>> clusters,
            Option<ListF<SnapshotAlbumPojo>> albums)
    {
        this.clusterizationType = clusterizationType;
        this.handle = handle;
        this.rev = rev;
        this.index = index.map(SnapshotIndexItemPojoHolder::new);
        this.clusters = clusters.map(SnapshotClusterPojoHolder::new);
        this.albums = albums.map(SnapshotAlbumsPojoHolder::new);
    }

    @BenderBindAllFields
    public static class SnapshotIndexItemPojoHolder {
        public final ListF<SnapshotIndexItemPojo> items;

        public SnapshotIndexItemPojoHolder(ListF<SnapshotIndexItemPojo> items) {
            this.items = items;
        }
    }

    @BenderBindAllFields
    public static class SnapshotClusterPojoHolder {
        public final ListF<SnapshotClusterPojo> items;

        public SnapshotClusterPojoHolder(ListF<SnapshotClusterPojo> items) {
            this.items = items;
        }
    }

    @BenderBindAllFields
    public static class SnapshotAlbumsPojoHolder {
        public final ListF<SnapshotAlbumPojo> items;

        public SnapshotAlbumsPojoHolder(ListF<SnapshotAlbumPojo> items) {
            this.items = items;
        }
    }
}
