package ru.yandex.chemodan.app.smartcache.client.http;

import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;

import ru.yandex.chemodan.app.dataapi.DataApiBenderUtils;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.smartcache.NS;
import ru.yandex.chemodan.app.smartcache.client.http.pojo.WorkerResponsePojo;
import ru.yandex.chemodan.app.smartcache.worker.actions.InitActionResponsePojo;
import ru.yandex.misc.bender.parse.BenderParser;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.io.http.apache.v4.ReadStringResponseHandler;

/**
 * @author osidorkin
 */
public class SmartcacheWorkerHttpProxy {

    private static final BenderParser<WorkerResponsePojo> workerInitResponseParser
                    = DataApiBenderUtils.mapper().createParser(WorkerResponsePojo.class);

    private final HttpClient httpClient;
    private final String workerUrl;

    public SmartcacheWorkerHttpProxy(HttpClient httpClient, String workerUrl) {
        this.httpClient = httpClient;
        this.workerUrl = workerUrl;
    }

    String buidRequestUrl(DataApiUserId uid, boolean albumsEnabled) {
        UriBuilder builder = UriBuilder.cons(workerUrl)
                .appendPath(NS.SMARTCACHE)
                .appendPath("photoslice-init-snapshot")
                .addParam("__resultType", "json")
                .addParam("__uid", uid)
                .addParam("albums", albumsEnabled);
        return builder.toUrl();
    }

    public InitActionResponsePojo initSnapshotOnWorker(DataApiUserId uid, boolean albumsEnabled) {
        return getSnapshotFromWorker(uid, albumsEnabled).result;
    }

    private WorkerResponsePojo getSnapshotFromWorker(DataApiUserId uid, boolean albumsEnabled) {
        return retrieveByHttpGet(buidRequestUrl(uid, albumsEnabled), workerInitResponseParser);
    }
    private <T> T retrieveByHttpGet(String url, BenderParser<T> parser) {
        return parser.parseJson(ApacheHttpClientUtils.execute(new HttpGet(url), httpClient, new ReadStringResponseHandler()));
    }
}
