package ru.yandex.chemodan.app.smartcache.worker;

import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.dataapi.AppInfoInvocationInterceptor;
import ru.yandex.chemodan.app.dataapi.DataApiBenderUtils;
import ru.yandex.chemodan.app.dataapi.web.DeltaParameterBinder;
import ru.yandex.chemodan.app.dataapi.web.binders.DataApiAppBinder;
import ru.yandex.chemodan.app.dataapi.web.binders.DataApiUserIdBinder;
import ru.yandex.chemodan.boot.ChemodanActionAppConfigurator;
import ru.yandex.chemodan.util.web.BenderJsonParameterBinder;
import ru.yandex.chemodan.util.web.interceptors.ThreadLocalCacheInterceptor;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.Feature;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.pojo.JsonPojoResultSerializer;
import ru.yandex.misc.bender.BenderMapper;

/**
 * @author Denis Bakharev
 */
@Configuration
public class ActionsContextConfiguration {

    @Bean
    public ActionApp actionApp(ApplicationContext context, ApplicationInfo applicationInfo) {

        BenderMapper generalBenderMapper = DataApiBenderUtils.mapper();

        ChemodanActionAppConfigurator configurator = ChemodanActionAppConfigurator.cons(applicationInfo, context);

        configurator.getBuilder()
                .addResultSerializers(Cf.list(
                        new JsonPojoResultSerializer(generalBenderMapper)
                ))

                .addParameterBinders(Cf.list(
                        new DataApiAppBinder(),
                        new DataApiUserIdBinder(),
                        new BenderJsonParameterBinder(generalBenderMapper),
                        new DeltaParameterBinder(generalBenderMapper)))

                .addInvocationInterceptors(Cf.list(
                        new ThreadLocalCacheInterceptor(),
                        new AppInfoInvocationInterceptor())
                )

                .disable(Feature.USE_SECURITY)
        ;

        return configurator.configure();
    }
}
