package ru.yandex.chemodan.app.smartcache.worker;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.dataapi.web.internal.InternalActionsContextConfiguration;
import ru.yandex.chemodan.app.smartcache.NS;
import ru.yandex.chemodan.util.web.A3JettyConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;

/**
 * @author osidorkin
 */
@Configuration
@Import ({
    InternalActionsContextConfiguration.class,
    SmartCacheCommonAppContextConfiugration.class,
    SmartCacheWorkerActionContextConfiguration.class,
    A3JettyContextConfiguration.class
})
public class PhotosliceWorkerDaemonContextConfiguration {

    @Bean
    public A3JettyConfiguration a3JettyServletsConfiguration() {
        return new A3JettyConfiguration(Tuple2List.fromPairs(
                "/smartcache/*", NS.SMARTCACHE,
                "/internal/*", NS.INTERNAL
        ));
    }
}
