package ru.yandex.chemodan.app.smartcache.worker;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.bazinga.BazingaWorkerTaskQueues;
import ru.yandex.chemodan.bazinga.ChemodanBazingaWorkerContextConfiguration;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTask;
import ru.yandex.commune.bazinga.pg.worker.PgBazingaWorkerConfiguration;
import ru.yandex.commune.bazinga.scheduler.TaskQueue;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        ChemodanBazingaWorkerContextConfiguration.class,
        SmartCacheTasksContextConfiguration.class,
})
public class SmartCacheBazingaContextConfiguration {

    @Bean
    public PgBazingaWorkerConfiguration pgBazingaWorkerConfiguration() {
        return new PgBazingaWorkerConfiguration(Cf.list(
                SmartCacheTaskQueueName.SMARTCACHE_CRON, CeleryOnetimeTask.BAZINGA_QUEUE_NAME));
    }

    @Bean
    public BazingaWorkerTaskQueues taskQueues(
            @Value("${bazinga.worker.photoslice-update.tasks.limit}") int updatersLimit,
            @Value("${bazinga.worker.photoslice-update.queue.size.coeff}") int updatersCoeff,
            @Value("${bazinga.worker.photoslice-update-limiters.tasks.limit}") int limitersLimit,
            @Value("${bazinga.worker.photoslice-update-limiters.queue.size.coeff}") int limitersCoeff,
            @Value("${bazinga.worker.init-albums.tasks.limit}") int initAlbumsLimit,
            @Value("${bazinga.worker.init-albums.queue.size.coeff}") int initAlbumsCoeff,
            @Value("${bazinga.worker.cleanup.tasks.limit}") int cleanupLimit,
            @Value("${bazinga.worker.cleanup.queue.size.coeff}") int cleanupCoeff)
    {
        return new BazingaWorkerTaskQueues(
                Option.of(SmartCacheTaskQueueName.SMARTCACHE_CRON),
                Option.of(SmartCacheTaskQueueName.SMARTCACHE_REGULAR),
                Option.empty(),
                Cf.list(
                        new TaskQueue(CeleryOnetimeTask.BAZINGA_QUEUE_NAME, 1, 0),
                        new TaskQueue(SmartCacheTaskQueueName.SMARTCACHE_PHOTOSLICE_UPDATE,
                                updatersLimit, updatersLimit * updatersCoeff),
                        new TaskQueue(SmartCacheTaskQueueName.SMARTCACHE_PHOTOSLICE_UPDATE_LIMITERS,
                                limitersLimit, limitersLimit * limitersCoeff),
                        new TaskQueue(SmartCacheTaskQueueName.SMARTCACHE_INIT_ALBUMS,
                                initAlbumsLimit, initAlbumsLimit * initAlbumsCoeff),
                        new TaskQueue(SmartCacheTaskQueueName.SMARTCACHE_CLEANUP,
                                cleanupLimit, cleanupLimit * cleanupCoeff)));
    }
}
