package ru.yandex.chemodan.app.smartcache.worker;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.smartcache.worker.actions.PhotosliceUpdateNotificationCeleryOnetimeTask;
import ru.yandex.chemodan.app.smartcache.worker.processing.PhotosliceProcessingManager;
import ru.yandex.chemodan.queller.worker.CeleryJavaWorkerContextConfiguration;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        CeleryJavaWorkerContextConfiguration.class
})
public class SmartCacheCeleryWorkerContextConfiguration {

    @Bean
    public PhotosliceUpdateNotificationCeleryOnetimeTask photosliceUpdateNotificationCeleryOnetimeTask(
            PhotosliceProcessingManager photosliceProcessingManager)
    {
        return new PhotosliceUpdateNotificationCeleryOnetimeTask(photosliceProcessingManager);
    }
}
