package ru.yandex.chemodan.app.smartcache.worker;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.smartcache.worker.actions.DropSnapshotAction;
import ru.yandex.chemodan.app.smartcache.worker.actions.InitAlbumsAction;
import ru.yandex.chemodan.app.smartcache.worker.actions.InitSnapshotAction;
import ru.yandex.chemodan.app.smartcache.worker.actions.PhotosliceUpdateNotificationAction;
import ru.yandex.chemodan.app.smartcache.worker.processing.PhotosliceProcessingManager;
import ru.yandex.chemodan.app.smartcache.worker.processing.PhotosliceTransitionManager;

/**
 * @author osidorkin
 */
@Configuration
@Import({
        ActionsContextConfiguration.class,
})
public class SmartCacheWorkerActionContextConfiguration {

    @Bean
    public InitSnapshotAction initSnapshotAction(PhotosliceProcessingManager photosliceProcessingManager) {
        return new InitSnapshotAction(photosliceProcessingManager);
    }

    @Bean
    public PhotosliceUpdateNotificationAction photosliceUpdateNotificationAction(
            PhotosliceProcessingManager photosliceProcessingManager)
    {
        return new PhotosliceUpdateNotificationAction(photosliceProcessingManager);
    }

    @Bean
    public DropSnapshotAction dropSnapshotAction(PhotosliceProcessingManager photosliceProcessingManager) {
        return new DropSnapshotAction(photosliceProcessingManager);
    }

    @Bean
    public InitAlbumsAction initAlbumsAction(PhotosliceTransitionManager photosliceTransitionManager) {
        return new InitAlbumsAction(photosliceTransitionManager);
    }
}
