package ru.yandex.chemodan.app.smartcache.worker;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.misc.ip.IpPort;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        PhotosliceWorkerDaemonContextConfiguration.class,
        SmartCacheBazingaContextConfiguration.class,
        /* XXX no production rabbit
        SmartCacheCeleryWorkerContextConfiguration.class,
        */
        SmartCacheContextConfiguration.class,
})
public class SmartCacheWorkerContextConfiguration {

    @Value("${monica.master.port}")
    private IpPort monicaPort;

    @Bean
    @Qualifier("monicaMasterPort")
    public IpPort monicaMasterPort() {
        return monicaPort;
    }
}
