package ru.yandex.chemodan.app.smartcache.worker.actions;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.geo.Coordinates;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class CoordsList {
    public final ListF<Coords> coordinates;

    public CoordsList(ListF<Coords> coordinates) {
        this.coordinates = coordinates;
    }

    public static class Coords {
        final String value;

        public Coords(String value) {
            this.value = value;
        }

        public Coordinates getCoordinates() {
            return parseCoords(value);
        }
    }

    private static Coordinates parseCoords(String str) {
        String[] chunks = str.split(",");
        double longitude = Double.parseDouble(chunks[0]);
        double latitude = Double.parseDouble(chunks[1]);
        return new Coordinates(latitude, longitude);
    }
}
