package ru.yandex.chemodan.app.smartcache.worker.actions;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.web.convert.ConvertToDataapiUser;
import ru.yandex.chemodan.app.smartcache.NS;
import ru.yandex.chemodan.app.smartcache.worker.processing.PhotosliceProcessingManager;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;

/**
 * @author osidorkin
 */
@Action(
        value = @Action.Alias(value = "drop-shapshot", namespace = NS.SMARTCACHE),
        description = "Удалить снапшот из базы")
@Path(value = "/photoslice-drop-snapshot", methods = HttpMethod.GET)
public class DropSnapshotAction extends PublicCloneableActionSupport {

    private static final OkPojo OK_POJO = new OkPojo();

    private final PhotosliceProcessingManager photosliceProcessingManager;

    @RequestParam(value = "__uid", customConverter = ConvertToDataapiUser.class)
    private DataApiUserId user;

    public DropSnapshotAction(PhotosliceProcessingManager photosliceProcessingManager) {
        this.photosliceProcessingManager = photosliceProcessingManager;
    }

    @Override
    public OkPojo execute() {
        photosliceProcessingManager.dropSnapshot(user);
        return OK_POJO;
    }

}
