package ru.yandex.chemodan.app.smartcache.worker.actions;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.web.convert.ConvertToDataapiUser;
import ru.yandex.chemodan.app.smartcache.NS;
import ru.yandex.chemodan.app.smartcache.worker.processing.PhotosliceTransitionManager;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;

/**
 * @author yashunsky
 */
@Action(
        value = @Action.Alias(value = "init-albums", namespace = NS.SMARTCACHE),
        description = "Разметить альбомы (ручка переходного периода)")
@Path(value = "/smartcache-init-albums", methods = {HttpMethod.GET, HttpMethod.POST})
public class InitAlbumsAction extends PublicCloneableActionSupport {

    @RequestParam(value = "__uid", customConverter = ConvertToDataapiUser.class)
    private DataApiUserId user;

    private final PhotosliceTransitionManager photosliceTransitionManager;

    public InitAlbumsAction(PhotosliceTransitionManager photosliceTransitionManager) {
        this.photosliceTransitionManager = photosliceTransitionManager;
    }

    @Override
    public Object execute() throws Exception {
        photosliceTransitionManager.scheduleInitAlbums(user);
        return new OkPojo();
    }
}
