package ru.yandex.chemodan.app.smartcache.worker.actions;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.web.convert.ConvertToDataapiUser;
import ru.yandex.chemodan.app.smartcache.NS;
import ru.yandex.chemodan.app.smartcache.worker.processing.PhotosliceProcessingManager;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;

/**
 * @author osidorkin
 */
@Action(
        value = @Action.Alias(value = "init-shapshot", namespace = NS.SMARTCACHE),
        description = "Создать снапшот, если не было и вернуть ревизию")
@Path(value = "/photoslice-init-snapshot", methods = HttpMethod.GET)
public class InitSnapshotAction extends PublicCloneableActionSupport {

    @RequestParam(value = "__uid", customConverter = ConvertToDataapiUser.class)
    private DataApiUserId user;
    @RequestParam
    private Option<Boolean> async;
    @RequestParam
    private Option<Boolean> albums;

    private final PhotosliceProcessingManager photosliceProcessingManager;

    public InitSnapshotAction(PhotosliceProcessingManager photosliceProcessingManager) {
        this.photosliceProcessingManager = photosliceProcessingManager;
    }

    @Override
    public Object execute() throws Exception {
        return photosliceProcessingManager
                .handleSnapshotInit(user, async.getOrElse(false), true, albums.getOrElse(false))
                .fold(InitActionResponsePojo::cons, jobId -> new OkPojo());
    }
}
